<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Menu extends Model 
{

    protected $table = 'menus';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->hasOne('App\User');
    }

    public function post_id()
    {
        return $this->belongsTo('App\Model\Post');
    }

    public function sub()
    {
        return $this->hasMany('App\Model\Menu', 'id', 'category_id');
    }

    public function site()
    {
        return $this->hasOne('App\Model\Site');
    }

}